// $Id: CScrollBar.cpp,v 1.6 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CScrollBar.hpp"
using Exponent::GUI::Controls::CScrollBar;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CScrollBar, CSlider);

//	===========================================================================
CScrollBar::CScrollBar(IControlRoot *root, const long uniqueId, const CRect &area, const CRect &virtualArea, IScrollListener *scrollListener) 
		  : CSlider(root, uniqueId, area, NULL)
		  , m_scrollListener(NULL)
		  , m_areaRatio(1.0)
		  , m_normalImages(NULL)
		  , m_mouseOverImage(NULL)
		  , m_mouseDownImages(NULL)
{
	EXPONENT_CLASS_CONSTRUCTION(CScrollBar);

	// Register the listener...
	this->registerScrollListener(scrollListener);
	this->registerActionListener(this);

	// Set the virtual area...
	this->setVirtualArea(virtualArea);
}

//	===========================================================================
CScrollBar::~CScrollBar()
{
	EXPONENT_CLASS_DESTRUCTION(CScrollBar);
	FORGET_COUNTED_OBJECT(m_normalImages);
	FORGET_COUNTED_OBJECT(m_mouseOverImage);
	FORGET_COUNTED_OBJECT(m_mouseDownImages);
}

//	===========================================================================
void CScrollBar::drawControl(CGraphics &graphics)
{
	// First check if we can allow the standard handler to draw the disabled control
	if (!this->drawEnabledControl(graphics))
	{
		return;
	}

	// Now draw the slider
	switch(m_state)
	{
		case CRolloverButton::e_mouseOff:
			if (m_normalImages)
			{
				m_normalImages->drawScrollBarImages(graphics, m_sliderPosition, m_isVertical);
			}
			else
			{
				CSlider::drawControl(graphics);
			}
		break;
		case CRolloverButton::e_mouseOver:
			if (m_mouseOverImage)
			{
				m_mouseOverImage->drawScrollBarImages(graphics, m_sliderPosition, m_isVertical);
			}
			else
			{
				CSlider::drawControl(graphics);
			}
		break;
		case CRolloverButton::e_mouseDown:
			if (m_mouseDownImages)
			{
				m_mouseDownImages->drawScrollBarImages(graphics, m_sliderPosition, m_isVertical);
			}
			else
			{
				CSlider::drawControl(graphics);
			}
		break;
	}
}

//	===========================================================================
void CScrollBar::registerScrollListener(IScrollListener *listener)
{
	m_scrollListener = listener;
}

//	===========================================================================
void CScrollBar::setVirtualArea(const CRect &virtualArea)
{
	// Store the virtual area
	m_virtualArea = virtualArea;

	// Handle based upon wether we are vertical or not
	if (m_isVertical)
	{
		// Copute the ratio of slider to area
		m_areaRatio = (double)m_area.getHeight() / (double)m_virtualArea.getHeight();

		// Setup the slider
		m_sliderPosition.setHeight((long)(m_area.getHeight() * m_areaRatio));
		m_sliderRange = (double)(m_area.getHeight() - m_sliderPosition.getHeight());
	}
	else
	{
		// Copute the ratio of slider to area
		m_areaRatio = (double)m_area.getWidth() / (double)m_virtualArea.getWidth();

		// Setup the slider
		m_sliderPosition.setWidth((long)(m_area.getWidth() * m_areaRatio));
		m_sliderRange = (double)(m_area.getWidth() - m_sliderPosition.getWidth());
	}

	// Redraw the window
	this->update();
}

//	===========================================================================
void CScrollBar::handleActionEvent(const CActionEvent &event)
{
	// Handle based upon wether we are vertical or not
	if (m_isVertical)
	{
		// Notify the listener
		if (m_scrollListener)
		{
			m_scrollListener->handleScrollEvent(CScrollEvent(CScrollEvent::e_scrollVertical, CRect(0, (long)((m_virtualArea.getHeight() - m_area.getHeight()) * (1.0 - m_value)), 0, m_sliderPosition.getHeight())));
		}
	}
	else
	{
		// Notify the listener
		if (m_scrollListener)
		{
			m_scrollListener->handleScrollEvent(CScrollEvent(CScrollEvent::e_scrollHorizontal, CRect((long)((m_virtualArea.getWidth() - m_area.getWidth()) * (1.0 - m_value)), 0, m_sliderPosition.getWidth(), 0)));
		}
	}
}

//	===========================================================================
void CScrollBar::setScrollBarImages(CScrollBarImages *normal, CScrollBarImages *mouseOver, CScrollBarImages *mouseDown)
{
	EXCHANGE_COUNTED_OBJECTS(m_normalImages,    normal);
	EXCHANGE_COUNTED_OBJECTS(m_mouseOverImage,  mouseOver);
	EXCHANGE_COUNTED_OBJECTS(m_mouseDownImages, mouseDown);
}